/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class PILPARConfigOps {
    private static final String DUMP_OPERATION = "dump";
    private static final String CLEAR_OPERATION = "clear";
    private static final int NUM_VALID_PARMS = 2;
    private String m_managedSystem;
    private String m_operation;
    private HashMap m_validParms = new HashMap(5, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PILPARConfigOps(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-o", null);
    }

    private int doClearOperation() throws PIHscClientException {
        int n;
        String string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LPCFGOP_CLEAR_CONFIRMATION");
        boolean bl = PIHMCCommandUtils.doConfirmation(string);
        if (bl) {
            this.m_CECClient.clearLPARConfiguration();
            n = 0;
        } else {
            n = 1;
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            if (bl) {
                this.m_out.print('\u0000');
            } else {
                this.m_out.print('\u0001');
            }
        }
        return n;
    }

    private void doDumpOperation() throws PIHscClientException {
        String string = this.m_CECClient.dumpLPARConfigImage();
        if (this.m_writeStatus) {
            this.m_out.print('\u0000');
            this.m_writeStatus = false;
        }
        this.m_out.println(HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "LPAR_CONFIG_DUMP_SUCCESS", "", new String[]{string}));
    }

    private int performCommand() throws PIHscClientException {
        int n = 0;
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n2 = pICECDataBean.getCecState().intValue();
        if (CLEAR_OPERATION.equals(this.m_operation)) {
            if (n2 != 17) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0227", null, null);
            }
            n = this.doClearOperation();
        } else if (DUMP_OPERATION.equals(this.m_operation)) {
            if (n2 != 17 && n2 != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
            }
            this.doDumpOperation();
        }
        return n;
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_operation == null || !DUMP_OPERATION.equals(this.m_operation) && !CLEAR_OPERATION.equals(this.m_operation)) {
            string = string + ", -o";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_operation = (String)hashMap.get("-o");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LPCFGOP_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PILPARConfigOps pILPARConfigOps = new PILPARConfigOps(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pILPARConfigOps.m_validParms);
            pILPARConfigOps.mapParameters(hashMap);
            n = pILPARConfigOps.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

